<?php
require_once '../db.php';

$update = json_decode(file_get_contents("php://input"), true);
$chat_id = $update["message"]["chat"]["id"];
$text = trim($update["message"]["text"]);

function sendMessage($chat_id, $text, $keyboard = null) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/sendMessage";
    $post = ['chat_id' => $chat_id, 'text' => $text, 'parse_mode' => 'HTML'];
    if ($keyboard) $post['reply_markup'] = json_encode(['keyboard' => $keyboard, 'resize_keyboard' => true]);
    file_get_contents($url . '?' . http_build_query($post));
}

if ($text == "/start" || $text == "محصولات") {
    $res = $conn->query("SELECT * FROM products");
    if ($res->num_rows > 0) {
        while ($row = $res->fetch_assoc()) {
            $btn = [['خرید ' . $row['id']]];
            $msg = "<b>{$row['title']}</b>
قیمت: {$row['price']} تومان
{$row['description']}";
            sendMessage($chat_id, $msg, $btn);
        }
    } else {
        sendMessage($chat_id, "محصولی موجود نیست.");
    }
} elseif (strpos($text, "خرید") !== false) {
    $pid = intval(str_replace("خرید ", "", $text));
    $conn->query("INSERT INTO orders (chat_id, product_id) VALUES ($chat_id, $pid)");
    $oid = $conn->insert_id;
    $url = BASE_URL . "/pay/zarinpal.php?order_id=" . $oid;
    sendMessage($chat_id, "برای پرداخت روی لینک زیر کلیک کنید:
$url");
}
?>